//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: client_button.cs
// brief:
//    This file contains functionality to sl-based gui
// controls using existing gui control functionality.  For
// example, a blinking feature for a particular SLImage would
// be implemented here because alpha control is already
// supported in SLImage and blinking is a feature dependent
// on controling the image's alpha.
//------------------------------------------------------------

// when a new mission is loaded for the first time, all buttons
// will be reset based on the button conditions set here
function LoadStartButtons()
{
   ShackButton.disabled = false;
   LogcabinButton.disabled = false;
   //HotelButton.disabled = false;
   WellButton.disabled = false;
   //FarmButton.disabled = false;
   //RanchButton.disabled = false;
   WoodhutButton.disabled = false;
   GoldMineButton.disabled = false;
   WatertowerButton.disabled = false;
   GranaryButton.disabled = false;
   //WindmillButton.disabled = false;
   //SmokehouseButton.disabled = false;
   GeneralButton.disabled = false;
   SaloonButton.disabled = false;
   //LumbermillButton.disabled = false;
   BlacksmithButton.disabled = false;
   SheriffsOfficeButton.disabled = false;
   TradingpostButton.disabled = false;
   //BankButton.disabled = false;
   //TownhallButton.disabled = false;
   WatchtowerButton.disabled = false;
   //BridgeButton.disabled = false;
   GazeboButton.disabled = false;
   ChurchButton.disabled = false;
   BarbershopButton.disabled = false;
   OuthouseButton.disabled = false;
   WelcomesignButton.disabled = false;
   FountainButton.disabled = false;
   //StatueButton.disabled = false;
   TownbellButton.disabled = false;
   FlowerpotButton.disabled = false;
   //CemeteryButton.disabled = false;
   HoneypotButton.input = false;
   HoneypotButton.disabled = true;
   HoneypotButton.iconEnabled = "";
}

$DefaultButtonList = 0;
$DefaultButtonCount = 0;

// when the main map is left to travel to a satellite map, the
// following buttons will be saved (only disabled states are saved)
function SaveDefaultButtons()
{
   // reset the first button
   $DefaultButtonCount = 0;
   
   // building buttons
   SaveDefaultButton(ShackButton);
   SaveDefaultButton(LogcabinButton);
   SaveDefaultButton(HotelButton);
   SaveDefaultButton(WellButton);
   SaveDefaultButton(FarmButton);
   SaveDefaultButton(RanchButton);
   SaveDefaultButton(WoodhutButton);
   SaveDefaultButton(GoldMineButton);
   SaveDefaultButton(WatertowerButton);
   SaveDefaultButton(GranaryButton);
   SaveDefaultButton(WindmillButton);
   SaveDefaultButton(SmokehouseButton);
   SaveDefaultButton(GeneralButton);
   SaveDefaultButton(SaloonButton);
   SaveDefaultButton(LumbermillButton);
   SaveDefaultButton(BlacksmithButton);
   SaveDefaultButton(SheriffsOfficeButton);
   SaveDefaultButton(TradingpostButton);
   SaveDefaultButton(BankButton);
   SaveDefaultButton(TownhallButton);
   SaveDefaultButton(WatchtowerButton);
   SaveDefaultButton(BridgeButton);
   SaveDefaultButton(GazeboButton);
   SaveDefaultButton(ChurchButton);
   SaveDefaultButton(BarbershopButton);
   SaveDefaultButton(OuthouseButton);
   SaveDefaultButton(WelcomesignButton);
   SaveDefaultButton(FountainButton);
   SaveDefaultButton(StatueButton);
   SaveDefaultButton(TownbellButton);
   SaveDefaultButton(FlowerpotButton);
   SaveDefaultButton(CemeteryButton);
   
   // character command button images
   SaveDefaultButton(CharCmdButton0);
   SaveDefaultButton(CharCmdButton1);
   SaveDefaultButton(CharCmdButton2);
   SaveDefaultButton(CharCmdButton3);
   SaveDefaultButton(CharCmdButton4);
   SaveDefaultButton(CharCmdButton5);
   SaveDefaultButton(CharCmdButton6);
   
   // character command button text
   SaveDefaultButton(CharCmdBtnText5);
   SaveDefaultButton(CharCmdBtnText6);
   
   // building command buttons images
   SaveDefaultButton(BldgCmdButton0);
   SaveDefaultButton(BldgCmdButton1);
   SaveDefaultButton(BldgCmdButton2);
   SaveDefaultButton(BldgCmdButton3);
   SaveDefaultButton(BldgCmdButton4);
   SaveDefaultButton(BldgCmdButton5);
   SaveDefaultButton(BldgCmdButton6);
   SaveDefaultButton(BldgCmdButton7);
   SaveDefaultButton(BldgCmdButton8);
   SaveDefaultButton(BldgCmdButton9);
   SaveDefaultButton(BldgCmdButton10);
   SaveDefaultButton(BldgCmdButton11);
   SaveDefaultButton(BldgCmdButton12);
   SaveDefaultButton(BldgCmdButton13);
   SaveDefaultButton(BldgCmdButton14);
   SaveDefaultButton(BldgCmdButton15);
   SaveDefaultButton(BldgCmdButton16);
   SaveDefaultButton(BldgCmdButton17);
   SaveDefaultButton(BldgCmdButton18);
   SaveDefaultButton(BldgCmdButton19);
   SaveDefaultButton(BldgCmdButton20);
   SaveDefaultButton(BldgCmdButton21);
   SaveDefaultButton(BldgCmdButton22);
   SaveDefaultButton(BldgCmdButton23);
   SaveDefaultButton(BldgCmdButton24);
   SaveDefaultButton(BldgCmdButton25);
   SaveDefaultButton(BldgCmdButton26);
   SaveDefaultButton(BldgCmdButton27);
   SaveDefaultButton(BldgCmdButton28);
   SaveDefaultButton(BldgCmdButton29);
   SaveDefaultButton(BldgCmdButton31);
   SaveDefaultButton(BldgCmdButton32);
   SaveDefaultButton(BldgCmdButton33);
   SaveDefaultButton(BldgCmdButton40);
   SaveDefaultButton(BldgCmdButton35);
   SaveDefaultButton(BldgCmdButton36);
   SaveDefaultButton(BldgCmdButton37);
   SaveDefaultButton(BldgCmdButton38);
   
   // building command buttons text
   SaveDefaultButton(BldgCmdBtnText0);
   SaveDefaultButton(BldgCmdBtnText1);
   SaveDefaultButton(BldgCmdBtnText2);
   SaveDefaultButton(BldgCmdBtnText3);
   SaveDefaultButton(BldgCmdBtnText4);
   SaveDefaultButton(BldgCmdBtnText5);
   SaveDefaultButton(BldgCmdBtnText9);
   SaveDefaultButton(BldgCmdBtnText10);
   SaveDefaultButton(BldgCmdBtnText11);
   SaveDefaultButton(BldgCmdBtnText12);
   SaveDefaultButton(BldgCmdBtnText29);
   SaveDefaultButton(BldgCmdBtnText31);
   SaveDefaultButton(BldgCmdBtnText32);   
}

// the buttons defaults states that were saved will be reloaded
// (only disabled states are loaded)
function LoadDefaultButtons()
{
   for (%index = 0; %index < $DefaultButtonCount; %index++)
   {
      %button = $DefaultButtonList[%index, 0];
      %button.disabled = $DefaultButtonList[%index, 1];
   }
}


// this is a save button helper function for saving a default
// button disabled state (the button will be reloaded in
// this state)
function SaveDefaultButton(%button)
{
   $DefaultButtonList[$DefaultButtonCount, 0] = %button;
   $DefaultButtonList[$DefaultButtonCount, 1] = %disabled.disabled;
   $DefaultButtonCount++;
}



$BlinkStartColor = "1 1 1 1";
$BlinkPeekColor = "1 1 0 1";
$TooltipFadeTime = 0.3;

// these function are used to set image and text buttons'
// alpha without having to parse the entire color and set
// the fourth component of the color
function SLImage::SetAlpha(%image, %alpha)
{
   %color = %image.color;
   %image.color = getWord(%color, 0) @ " " @ getWord(%color, 1) @
      " " @ getWord(%color, 2) @ " " @ %alpha;
}

function SLText::SetAlpha(%text, %alpha)
{
   %color = %text.color;
   %text.color = getWord(%color, 0) @ " " @ getWord(%color, 1) @
      " " @ getWord(%color, 2) @ " " @ %alpha;
}

function SLGuiTarget::SetAlpha(%target, %alpha)
{
   %target.alpha = %alpha;
}

function SLHud::SetAlpha(%hud, %alpha)
{
   %hud.alpha = %alpha;
}



// these functions are used to stop any fading that is
// currently being done to image and text buttons
function SLImage::StopFade(%image)
{
   if (isObject(%image.fadeTimer) == true)
   {
      %image.fadeTimer.delete();
      %image.fadeTimer = 0;
   }
   
   %image.fadingIn = false;
   %image.fadingOut = false;
}

function SLText::StopFade(%text)
{
   if (isObject(%text.fadeTimer) == true)
   {
      %text.fadeTimer.delete();
      %text.fadeTimer = 0;
   }
   
   %text.fadingIn = false;
   %text.fadingOut = false;
}

function SLGuiTarget::StopFade(%target)
{
   if (isObject(%target.fadeTimer) == true)
   {
      %target.fadeTimer.delete();
      %target.fadeTimer = 0;
   }
   
   %target.fadingIn = false;
   %target.fadingOut = false;
}

function SLHud::StopFade(%hud)
{
   if (isObject(%hud.fadeTimer) == true)
   {
      %hud.fadeTimer.delete();
      %hud.fadeTimer = 0;
   }
   
   %hud.fadingIn = false;
   %hud.fadingOut = false;
}

// when a button should fade from completely transparent to
// completely opaque, this function should be called for
// image and text buttons
function SLImage::FadeIn(%image, %duration)
{
   %image.StopFade();
   %image.StopBlink();
   
   %image.fadeTimer = %timer = new SLTimer()
   {
      time = %duration;
   };
   %timer.notifyOnUpdate(FadeInUpdate, %timer);
   %timer.notifyOnFire(FadeInFire, %timer);

   %timer.duration = %duration;
   %timer.button = %image;
   %image.SetAlpha(0);
   
   %image.fadingIn = true;
}

function SLText::FadeIn(%text, %duration)
{
   %text.StopFade();
   %text.StopBlink();
   
   %text.fadeTimer = %timer = new SLTimer()
   {
      time = %duration;
   };
   %timer.notifyOnUpdate(FadeInUpdate, %timer);
   %timer.notifyOnFire(FadeInFire, %timer);

   %timer.duration = %duration;
   %timer.button = %text;
   %text.SetAlpha(0);
   
   %text.fadingIn = true;
}

function SLGuiTarget::FadeIn(%target, %duration)
{
   %target.StopFade();

   %target.fadeTimer = %timer = new SLTimer()
   {
      time = %duration;
   };
   %timer.notifyOnUpdate(FadeInUpdate, %timer);
   %timer.notifyOnFire(FadeInFire, %timer);

   %timer.duration = %duration;
   %timer.button = %target;
   %target.SetAlpha(0);
   
   %target.fadingIn = true;
}

function SLHud::FadeIn(%hud, %duration)
{
   %hud.StopFade();

   %hud.fadeTimer = %timer = new SLTimer()
   {
      time = %duration;
   };
   %timer.notifyOnUpdate(FadeInUpdate, %timer);
   %timer.notifyOnFire(FadeInFire, %timer);

   %timer.duration = %duration;
   %timer.button = %hud;
   %hud.SetAlpha(0);
   
   %hud.fadingIn = true;
}

function SLTimer::FadeInUpdate(%this, %time)
{
   if (%this.duration == 0)
   {
      SetAlpha(%this, 1);
      return;
   }
   
   %alpha = 1 - (%this.duration - %time) / %this.duration;
   %this.button.SetAlpha(%alpha);
}

function SLTimer::FadeInFire(%this, %time)
{
   %this.button.SetAlpha(1);
}



// fades a button out
function SLImage::FadeOut(%image, %duration)
{
   %image.StopFade();
   %image.StopBlink();
   
   %timer = new SLTimer()
   {
      time = %duration;
   };
   %image.fadeTimer = %timer;
   
   %timer.notifyOnUpdate(FadeOutUpdate, %timer);
   %timer.notifyOnFire(FadeOutFire, %timer);

   %timer.duration = %duration;
   %timer.button = %image;
   %image.SetAlpha(1);
   
   %image.fadingOut = true;
}

function SLText::FadeOut(%text, %duration)
{
   %text.StopFade();
   %text.StopBlink();
   
   %timer = new SLTimer()
   {
      time = %duration;
   };
   %text.fadeTimer = %timer;
   
   %timer.notifyOnUpdate(FadeOutUpdate, %timer);
   %timer.notifyOnFire(FadeOutFire, %timer);

   %timer.duration = %duration;
   %timer.button = %text;
   %text.SetAlpha(1);
   
   %text.fadingOut = true;
}

function SLGuiTarget::FadeOut(%target, %duration)
{
   %target.StopFade();
   
   %timer = new SLTimer()
   {
      time = %duration;
   };
   %target.fadeTimer = %timer;
   
   %timer.notifyOnUpdate(FadeOutUpdate, %timer);
   %timer.notifyOnFire(FadeOutFire, %timer);

   %timer.duration = %duration;
   %timer.button = %target;
   %target.SetAlpha(1);
   
   %target.fadingOut = true;
}

function SLHud::FadeOut(%hud, %duration)
{
   %hud.StopFade();
   
   %timer = new SLTimer()
   {
      time = %duration;
   };
   %hud.fadeTimer = %timer;
   
   %timer.notifyOnUpdate(FadeOutUpdate, %timer);
   %timer.notifyOnFire(FadeOutFire, %timer);

   %timer.duration = %duration;
   %timer.button = %hud;
   %hud.SetAlpha(1);
   
   %hud.fadingOut = true;
}

function SLTimer::FadeOutUpdate(%this, %time)
{
   if (isObject(%this.button) == false)
   {
      %this.delete();
      return;
   }
   
   if (%this.duration == 0)
   {
      SetAlpha(%this, 0);
      return;
   }
   
   %alpha = (%this.duration - %time) / %this.duration;
   %this.button.SetAlpha(%alpha);
}

function SLTimer::FadeOutFire(%this, %time)
{
   if (isObject(%this.button) == false)
   {
      return;
   }
   
   %this.button.SetAlpha(0);
}



// makes a button flash
function SLImage::StopBlink(%image)
{
   if (isObject(%image.blinkTimer) == true)
   {
      %image.blinkTimer.delete();
      %image.blinkTimer = 0;
   }
   
   %image.blinking = false;
}

function SLText::StopBlink(%text)
{
   if (isObject(%text.blinkTimer) == true)
   {
      %text.blinkTimer.delete();
      %text.blinkTimer = 0;
   }
   
   %text.blinking = false;
}

function SLImage::Blink(%image, %duration, %count, %startColor, %peekColor)
{
   %image.StopFade();
   %image.StopBlink();
   
   if (%count <= 0 || %duration <= 0)
   {
      return;
   }

   %count *= 2;
   %duration /= %count;

   %image.blinkTimer = %timer = new SLTimer()
   {
      time = %duration;
   };
   
   %timer.notifyOnUpdate(BlinkUpdate, %timer);
   %timer.notifyOnFire(BlinkFire, %timer);

   %timer.startColor = %startColor;
   %timer.stopColor = %peekColor;
   %timer.duration = %duration;
   %timer.count = %count - 1;
   %timer.button = %image;
}

function SLText::Blink(%text, %duration, %count, %startColor, %peekColor)
{
   %text.StopFade();
   %text.StopBlink();
   
   if (%count <= 0 || %duration <= 0)
   {
      return;
   }

   %count *= 2;
   %duration /= %count;

   %text.blinkTimer = %timer = new SLTimer()
   {
      time = %duration;
   };
   
   %timer.notifyOnUpdate(BlinkUpdate, %timer);
   %timer.notifyOnFire(BlinkFire, %timer);

   %timer.startColor = %startColor;
   %timer.stopColor = %peekColor;
   %timer.duration = %duration;
   %timer.count = %count - 1;
   %timer.button = %text;
}

function SLTimer::BlinkUpdate(%this, %time)
{
   %fraction = (%this.duration - %time) / %this.duration;
   %red = getWord(%this.startColor, 0) * %fraction +
      getWord(%this.stopColor, 0) * (1 - %fraction);
   %green = getWord(%this.startColor, 1) * %fraction +
      getWord(%this.stopColor, 1) * (1 - %fraction);
   %blue = getWord(%this.startColor, 2) * %fraction +
      getWord(%this.stopColor, 2) * (1 - %fraction);
   %alpha = getWord(%this.startColor, 3) * %fraction +
      getWord(%this.stopColor, 3) * (1 - %fraction);
   %this.button.color = %red @ " " @ %green @ " " @ %blue @ " " @ %alpha;
}

function SLTimer::BlinkFire(%this, %time)
{
   %this.button.color = %this.stopColor;
   if (%this.count == 0)
   {
      %this.blinkTimer = 0;
      return;
   }
   
   %this.button.blinkTimer = %timer = new SLTimer()
   {
      time = %this.duration;
   };
   
   %timer.notifyOnUpdate(BlinkUpdate, %timer);
   %timer.notifyOnFire(BlinkFire, %timer);

   %timer.startColor = %this.stopColor;
   %timer.stopColor = %this.startColor;
   %timer.duration = %this.duration;
   %timer.count = %this.count - 1;
   %timer.button = %this.button;
}

function SLImage::onToolTipBegin(%this)
{
   // Show Hud
   PopUpHud.Visible = true;
   PopUpHud.FadeIn($TooltipFadeTime);
   
   // Play sound
   playSFXSound(AudioDialogPopup);
   
   // Fill locked information
   if (%this.xpCheck !$= "")
   {
      PopUpLocked.textUp = slgGetObjectString("locked_desc");
      PopUpLocked.Visible = true;
   }
   else
   {
      PopUpLocked.Visible = false;
   }
   
   // Fill description information
   PopUpName.stateUp = slgGetObjectString(%this.getName() @ "_name");
   
   if (%this.disabled == true)
   {
      PopUpDescription.stateUp = slgGetObjectString(%this.getName() @ "_disabled");
   }
   else if (%this.selected == true)
   {
      PopUpDescription.stateUp = slgGetObjectString(%this.getName() @ "_selected");
   }
   else
   {
      PopUpDescription.stateUp = slgGetObjectString(%this.getName() @ "_desc");
   }
   
   // Fill gold and wood information
   PopUpGold.stateUp = %this.buildingData.goldCost;
   PopUpWood.stateUp = %this.buildingData.woodCost;
}

function SLImage::onToolTipEnd(%this)
{
   // Hide Hud
   //PopUpHud.FadeOut($TooltipFadeTime);
   PopUpHud.Visible = false;
}

function SLImage::onCommandToolTipBegin(%this)
{
   // Show Hud
   CommandPopUpHud.Visible = true;
   CommandPopUpHud.FadeIn($TooltipFadeTime);
   
   // Play sound
   playSFXSound(AudioDialogPopup);
   
   // Fill locked information
   if (%this.xpCheck !$= "")
   {
      CommandPopUpLocked.textUp = slgGetObjectString("locked_desc");
      CommandPopUpLocked.Visible = true;
   }
   else
   {
      CommandPopUpLocked.Visible = false;
   }
   
   if (%this.disabled == true)
   {
      CommandPopUpDescription.stateUp = slgGetObjectString(%this.getName() @ "_disabled");
   }
   else if (%this.selected == true)
   {
      CommandPopUpDescription.stateUp = slgGetObjectString(%this.getName() @ "_selected");
   }
   else
   {
      CommandPopUpDescription.stateUp = slgGetObjectString(%this.getName() @ "_desc");
   }
}

function SLImage::onCommandToolTipEnd(%this)
{
   // Hide Hud
   //PopUpHud.FadeOut($TooltipFadeTime);
   CommandPopUpHud.Visible = false;
}




// this turns off the notify blink for the button
function StopNotifyBlink(%button)
{
   if (isObject(%button.notifyBlink) == false)
   {
      return;
   }
   
   // reset the up state for the button to the appropriate state
   %timer = %button.notifyBlink;
   %button.stateUp = %timer.up;
   %timer.delete();
}





function NotifyBlink(%button, %upDuration, %focusDuration, %blinkCount)
{
   StopNotifyBlink(%button);
   
   %timer = new SLTimer()
   {
      time = %upDuration;
   };
   %timer.upTime = %upDuration;
   %timer.focusTime = %focusDuration;
   %timer.count = 0;
   %timer.maxCount = %blinkCount;
   %timer.up = %button.stateUp;
   %timer.focus = %button.stateFocus;
   %timer.button = %button;
   %timer.notifyOnFire("NotifyBlinkFocus", %timer);
   
   %button.notifyBlink = %timer;
}

function SLTimer::NotifyBlinkFocus(%timer)
{
   %timer.button.stateUp = %timer.focus;
   
   %newTimer = new SLTimer()
   {
      time = %timer.focusTime;
   };
   %newTimer.upTime = %timer.upTime;
   %newTimer.focusTime = %timer.focusTime;
   %newTimer.count = %timer.count + 1;
   %newTimer.maxCount = %timer.maxCount;
   %newTimer.up = %timer.up;
   %newTimer.focus = %timer.focus;
   %newTimer.button = %timer.button;
   %newTimer.notifyOnFire("NotifyBlinkUp", %newTimer);
   
   %timer.button.notifyBlink = %newTimer;
}

function SLTimer::NotifyBlinkUp(%timer)
{
   %timer.button.stateUp = %timer.up;
   if (%timer.count >= %timer.maxCount)
   {
      return;
   }
   
   %newTimer = new SLTimer()
   {
      time = %timer.upTime;
   };
   %newTimer.upTime = %timer.upTime;
   %newTimer.focusTime = %timer.focusTime;
   %newTimer.count = %timer.count;
   %newTimer.maxCount = %timer.maxCount;
   %newTimer.up = %timer.up;
   %newTimer.focus = %timer.focus;
   %newTimer.button = %timer.button;
   %newTimer.notifyOnFire("NotifyBlinkFocus", %newTimer);
   
   %timer.button.notifyBlink = %newTimer;
}




function SLItemBase::SaveToFile(%base)
{
   slgSaveBool(%base.input);
   slgSaveBool(%base.visible);
   slgSaveBool(%base.disabled);
   slgSaveBool(%base.selected);
   slgSaveBool(%base.xpCheck $= "");
}

function SLImage::SaveToFile(%image)
{
   SLItemBase::SaveToFile(%image);
   
   if (%image.fadingIn == true && isObject(%image.fadeTimer))
   {
      slgSaveInt(1);
      %timer = %image.fadeTimer;
      slgSaveFloat(%timer.getElapsedTime());
      slgSaveFloat(%timer.getTotalTime());
      slgSaveFloat(getWord(%image.color, 3));
   }
   else if (%image.fadingOut == true && isObject(%image.fadeTimer))
   {
      slgSaveInt(2);
      %timer = %image.fadeTimer;
      slgSaveFloat(%timer.getElapsedTime());
      slgSaveFloat(%timer.getTotalTime());
      slgSaveFloat(getWord(%image.color, 3));
   }
   else if (%image.blinking == true && isObject(%image.blinkTimer))
   {
      slgSaveInt(3);
      %timer = %image.blinkTimer;
      slgSaveFloat(%timer.getElapsedTime());
      slgSaveFloat(%timer.getTotalTime());
      slgSaveString(%timer.startColor);
      slgSaveString(%timer.stopColor);
      slgSaveInt(%timer.count);
      slgSaveFloat(getWord(%image.color, 3));
   }
   else
   {
      slgSaveInt(0);
   }
}

function SLText::SaveToFile(%text)
{
   SLItemBase::SaveToFile(%text);
   
   if (%text.fadingIn == true)
   {
      slgSaveInt(1);
      %timer = %text.fadeTimer;
      slgSaveFloat(%timer.getElapsedTime());
      slgSaveFloat(%timer.getTotalTime());
      slgSaveFloat(getWord(%text.color, 3));
   }
   else if (%text.fadingOut == true)
   {
      slgSaveInt(2);
      %timer = %text.fadeTimer;
      slgSaveFloat(%timer.getElapsedTime());
      slgSaveFloat(%timer.getTotalTime());
      slgSaveFloat(getWord(%text.color, 3));
   }
   else if (%text.blinking == true)
   {
      slgSaveInt(3);
      %timer = %text.blinkTimer;
      slgSaveFloat(%timer.getElapsedTime());
      slgSaveFloat(%timer.getTotalTime());
      slgSaveString(%timer.startColor);
      slgSaveString(%timer.stopColor);
      slgSaveInt(%timer.count);
      slgSaveFloat(getWord(%text.color, 3));
   }
   else
   {
      slgSaveInt(0);
   }
}




function SLItemBase::LoadFromFile(%base)
{
   %base.input = slgLoadBool();
   %base.visible = slgLoadBool();
   %base.disabled = slgLoadBool();
   %base.selected = slgLoadBool();
   if (slgLoadBool() == true)
   {
      %base.xpCheck = "";
   }
}

function SLImage::LoadFromFile(%image)
{
   SLItemBase::LoadFromFile(%image);
   
   %image.StopFade();
   %image.StopBlink();
   
   %type = slgLoadInt();
   if (%type == 1)
   {
      %image.fadingIn = true;
      %elapsedTime = slgLoadFloat();
      %totalTime = slgLoadFloat();

      %image.fadeTimer = %timer = new SLTimer()
      {
         time = %totalTime;
      };
      %timer.setElapsedTime(%elapsedTime);
      %timer.notifyOnUpdate(FadeInUpdate, %timer);
      %timer.notifyOnFire(FadeInFire, %timer);
      %timer.duration = %totalTime;
      %timer.button = %image;
      
      %image.SetAlpha(slgLoadFloat());
   }
   else if (%type == 2)
   {
      %image.fadingOut = true;
      %elapsedTime = slgLoadFloat();
      %totalTime = slgLoadFloat();
      
      %image.fadeTimer = %timer = new SLTimer()
      {
         time = %totalTime;
      };
      %timer.setElapsedTime(%elapsedTime);
      %timer.notifyOnUpdate(FadeOutUpdate, %timer);
      %timer.notifyOnFire(FadeOutFire, %timer);
      %timer.duration = %totalTime;
      %timer.button = %image;
      
      %image.SetAlpha(slgLoadFloat());
   }
   else if (%type == 3)
   {
      %image.blinking = true;
      %elapsedTime = slgLoadFloat();
      %totalTime = slgLoadFloat();
      
      %image.blinkTimer = %timer = new SLTimer()
      {
         time = %totalTime;
      };
      
      %timer.notifyOnUpdate(BlinkUpdate, %timer);
      %timer.notifyOnFire(BlinkFire, %timer);
      %timer.startColor = slgLoadString();
      %timer.stopColor = slgLoadString();
      %timer.duration = %totalTime;
      %timer.count = slgLoadInt();
      %timer.button = %image;
      
      %image.SetAlpha(slgLoadFloat());
   }
}

function SLText::LoadFromFile(%text)
{
   SLItemBase::LoadFromFile(%text);
   
   %text.StopFade();
   %text.StopBlink();
   
   %type = slgLoadInt();
   if (%type == 1)
   {
      %text.fadingIn = true;
      %elapsedTime = slgLoadFloat();
      %totalTime = slgLoadFloat();

      %text.fadeTimer = %timer = new SLTimer()
      {
         time = %totalTime;
      };
      %timer.setElapsedTime(%elapsedTime);
      %timer.notifyOnUpdate(FadeInUpdate, %timer);
      %timer.notifyOnFire(FadeInFire, %timer);
      %timer.duration = %totalTime;
      %timer.button = %text;
      
      %text.SetAlpha(slgLoadFloat());
   }
   else if (%type == 2)
   {
      %text.fadingOut = true;
      %elapsedTime = slgLoadFloat();
      %totalTime = slgLoadFloat();
      
      %text.fadeTimer = %timer = new SLTimer()
      {
         time = %totalTime;
      };
      %timer.setElapsedTime(%elapsedTime);
      %timer.notifyOnUpdate(FadeOutUpdate, %timer);
      %timer.notifyOnFire(FadeOutFire, %timer);
      %timer.duration = %totalTime;
      %timer.button = %text;
      
      %text.SetAlpha(slgLoadFloat());
   }
   else if (%type == 3)
   {
      %text.blinking = true;
      %elapsedTime = slgLoadFloat();
      %totalTime = slgLoadFloat();
      
      %text.blinkTimer = %timer = new SLTimer()
      {
         time = %totalTime;
      };
      
      %timer.notifyOnUpdate(BlinkUpdate, %timer);
      %timer.notifyOnFire(BlinkFire, %timer);
      %timer.startColor = slgLoadString();
      %timer.stopColor = slgLoadString();
      %timer.duration = %totalTime;
      %timer.count = slgLoadInt();
      %timer.button = %text;
      
      %text.SetAlpha(slgLoadFloat());
   }
}

function SLTextImage::buttonDown(%this)
{
   // Hide cost of button if there is one   
   if(%this.btnIndex !$= "") {
      // Get selected object
      %selObj = getSelectedObject(0);
      if(isObject(%selObj)) {
         // Get command button text
         %btnText = csGetCmdBtnText(%selObj, %this.btnIndex);
         if(isObject(%btnText)) {
            %btnText.Visible = false;
         }
      }
   }
}

function SLTextImage::buttonUnfocus(%this)
{
   // Show cost of button if there is one
   if(%this.btnIndex !$= "" && !%this.selected) {
      // Get selected object
      %selObj = getSelectedObject(0);
      if(isObject(%selObj)) {
         // Get command button text
         %btnText = csGetCmdBtnText(%selObj, %this.btnIndex);
         if(isObject(%btnText)) {
            %btnText.Visible = true;
         }
      }
   }
}